<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Package;
use App\Models\Therapist;
use App\Models\Slot;
use App\Models\UserReview;
use App\Models\Coupons;
use App\Models\Prescription;
use App\Models\ConsulationNote;
use App\Models\WorkingHours;
use App\Models\SlotShedule;
use App\Models\Appointments;
use App\Models\ServiceFeeStructure;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Illuminate\Database\QueryException;
use App\Models\UserWalletTransactions;
use App\Models\UserWallet;
use App\Models\TypesOfWallet;
use App\Models\WalletPoint;
use Illuminate\Support\Facades\DB;

class BookingController extends Controller
{

    public function getPackages(Request $request)
    {
        $data = [];
        $data['service_id'] = $request->service_id;
        $data['therapist'] = Therapist::select('id', 'full_name', 'designation', 'language_known', 'image')->where('id', $request->therapist_id)->first();
        $data['therapist']->image = asset('assets/uploads/therapist/') . '/' . $data['therapist']->image;

        $data['packages'] = Package::select('id', 'service_fee_id', 'title', 'no_of_sessions', 'discount', 'description', 'image')->where('service_id', $request->service_id)->where('status', 'ACTIVE')->get();
        $pc = $request->provider_category_id;
        $data['packages'] = collect($data['packages']->toArray())->map(function ($item) use ($pc) {

            $sfs = ServiceFeeStructure::whereIn('id', json_decode($item['service_fee_id']))->with('callMethod')->where('provider_category_id', $pc)->get();
            $discount = $item['discount'];
            $item['communication_methods'] = collect($sfs->toArray())->map(function ($item2) use ($discount) {
                $item['call_method_id'] = $item2['call_method_id'];
                $item['call_method'] = $item2['call_method']['name'];
                $item['actual_fee'] = $item2['rate'];
                $subtotal = $item2['rate'] * ($discount / 100);
                $item['discount_fee'] = $item2['rate'] -  $subtotal;
                return $item;
            });

            $item['image'] = asset('assets/uploads/package/') . '/' . $item['image'];
            $item['description'] = Str::limit((strip_tags($item['description'])), 50, '...');
            $item['description'] = preg_replace("/&nbsp;/", '', $item['description']);
            $item['description'] = preg_replace("/\s+/", " ", $item['description']);
            return $item;
        });


        $sfs = ServiceFeeStructure::where('service_id', $request->service_id)->where('provider_category_id', $request->provider_category_id)->get();

        foreach ($sfs as $key => $item) {
            $call_methods[$key] = [
                'id' => $item->callMethod->id,
                'name' => $item->callMethod->name,
                'fee' => $item->rate
            ];
        }
        $data['fee_structure'] = $call_methods;
        $item = collect($call_methods)->unique()->values();

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function searchSlot(Request $request)
    {

        $current_date = date("Y-m-d");
        $current_time = date("H:i");
        $html = '';
        $data = [];
        $booking_date = date("Y-m-d", strtotime($request->bookingDate));
        $error = 'No slots Found';
        $day = Carbon::createFromFormat('Y-m-d', $request->bookingDate)->format('l');
        $service = $request->service;

        $slot = Slot::where('therapist_id', $request->therapist)->first();

        if ($slot) {
            $workinghours = WorkingHours::where('slot_id', $slot->id)
                ->where('day', $day)
                ->where('service_id', $service)
                ->first();


            if ($workinghours) {

                $slotlist = SlotShedule::where('slot_id', $workinghours->id)->where('call_method_id', $request->callmethod)->first();

                if ($slotlist) {
                    $i = 0;
                    $j = 0;
                    foreach (json_decode($slotlist->slots) as $key => $x) {
                        //***** */
                        $slot_flag = 0;
                        $bookedslots = Appointments::where('therapist_id', $request->therapist)->where('Appointment_Date', $booking_date)->get();
                        if ($bookedslots) {
                            foreach ($bookedslots as $bookedslot) {
                                $booked_slotlist = SlotShedule::where('id', $bookedslot->slot_id)->first();
                                $flag = 0;
                                $next_booked_slot = '';
                                $prev_slot = '';
                                $prev = '';

                                foreach (json_decode($booked_slotlist->slots) as $k => $bs) {
                                    if ($bookedslot->Appointment_Time == $bs) {

                                        $flag = 1;
                                        continue;
                                    } else {
                                        if ($flag == 1) {
                                            $prev = $prev_slot;
                                            $next_booked_slot = $bs;
                                            break;
                                        }
                                    }
                                    $prev_slot = $bs;
                                }
                                $prev = $prev_slot;

                                $time1  = date("H:i", strtotime($bookedslot->Appointment_Time));
                                $time2 = date("H:i", strtotime($next_booked_slot));
                                $time3 = date("H:i", strtotime($prev));
                                $checkedtime = date("H:i", strtotime($x));

                                if (($checkedtime >= $time1 && $checkedtime < $time2) || ($checkedtime > $time3 && $checkedtime <= $time1)) {
                                    $slot_flag = 1;
                                    break;
                                }
                            }
                        }
                        if ($slot_flag == 1) {

                            continue;
                        }
                        //*** */
                        $givenDateTime = date("H:i", strtotime($x));


                        if ($current_date == $request->bookingDate) {

                            if ($current_time < $givenDateTime) {

                                $data[$i]['slot_id'] = $slotlist->id;
                                $booked = Appointments::where('slot_id', $slotlist->id)->where('Appointment_Time', $x)->where('Appointment_Date', $booking_date)->first();
                                $data[$i]['slots'] = $x;
                                if ($booked) {
                                    $data[$i]['slot_status'] = $booked->Appointment_Status;
                                } else {
                                    $data[$i]['slot_status'] = 'Available';
                                }
                                $i++;
                            }
                        } else {

                            $data[$j]['slot_id'] = $slotlist->id;
                            $booked = Appointments::where('slot_id', $slotlist->id)->where('Appointment_Time', $x)->where('Appointment_Date', $booking_date)->first();
                            $data[$j]['slots'] = $x;
                            if ($booked) {
                                $data[$j]['slot_status'] = $booked->Appointment_Status;
                            } else {
                                $data[$j]['slot_status'] = 'Available';
                            }
                            $j++;
                        }
                    }

                    return response()->json(
                        array(
                            'status' => True,
                            'data' => $data
                        ),
                        200
                    );
                } else {

                    return response()->json(
                        array(
                            'status' => False,
                            'data' => $error
                        ),
                        200
                    );
                }
            } else {
                return response()->json(
                    array(
                        'status' => False,
                        'data' => $error
                    ),
                    200
                );
            }
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $error
                ),
                200
            );
        }

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function packageBooking(Request $request)
    {
        $data = [];
        $call_methods = [];
        $grandtotal = 0;
        $array = Package::select('id', 'service_id', 'service_fee_id', 'title', 'no_of_sessions', 'discount', 'description', 'image')->where('id', $request->package_id)->first();
        $data = $array;
        $service_ids = json_decode($array->service_fee_id);
        $sfs = ServiceFeeStructure::whereIn('id', $service_ids)->where('provider_category_id', $request->provider_category)->first();

        $total = $sfs->rate * $array->no_of_sessions;
        $subtotal = $total * ($array->discount / 100);
        $grandtotal = $total - $subtotal;

        if ($sfs) {

            $data['communication_method_id'] = $sfs->callMethod->id;
            $data['communication_method'] = $sfs->callMethod->name;
            $data['actual_price'] = $sfs->rate;
            $data['discount_price'] = $grandtotal;
        }

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function getCoupons(Request $request)
    {
        $data = Coupons::select('id', 'promo_code', 'discount_type', 'discount_rate')->where('start_date', '<=', Carbon::now())->where('expiry_date', '>=', Carbon::now())->first();
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }


    public function addCoupons(Request $request)
    {
        $total = 0;
        $data = Coupons::where('id', $request->coupon_code)->first();

        if ($data->discount_type == '%') {
            $total = $request->total * ($data->discount_rate / 100);
            $total = $request->total - $total;
        } else {
            $total = $request->total - $request->coupon_code;
        }
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $total
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function bookAppoinment(Request $request)
    {

        $userwallet = UserWallet::where('user_id', auth()->user()->id)->first();
        if ($userwallet->balance < $request->fee) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Your wallet account does not have sufficient balance."
                ),
                200
            );
        }
        $booking_date = date("Y-m-d", strtotime($request->booking_date));
        $dob = date("Y-m-d", strtotime($request->dob));
        $exist = Appointments::where('Appointment_Date', $booking_date)->where('slot_id', $request->slot_id)->where('Appointment_Time', $request->slot)->first();
        if ($exist != null) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Your already Booked this slot"
                ),
                200
            );
        }
        try {
            if ($request->package_id) {
                $packageid = $request->package_id;
            } else {
                $packageid = null;
            }
            $appointment = new Appointments();
            $appointment->Appointment_Type = $request->call_type;
            $appointment->Appointment_Date = $booking_date;
            $appointment->Appointment_Time = $request->slot;
            $appointment->Appointment_Booked_Date = date("Y-m-d", strtotime(now()));
            $appointment->Appointment_Booked_Time = date("H:i:s", strtotime(now()));
            $appointment->therapist_id = $request->therapist;
            $appointment->service_id = $request->service;
            $appointment->slot_id = $request->slot_id;
            $appointment->user_id = auth()->user()->id;
            $appointment->package_id = $packageid;
            $appointment->fee = $request->fee;
            $appointment->save();

            $point = WalletPoint::orderBy('id', 'DESC')->first();
            $userpoint = $point->point * $request->fee;

            $userWalletTransaction = new UserWalletTransactions();
            $userWalletTransaction->user_id = auth()->user()->id;
            $userWalletTransaction->wallet_id = 1;
            $userWalletTransaction->type = 'Debit';
            $userWalletTransaction->amount = $request->fee;
            $userWalletTransaction->point = $userpoint;
            $userWalletTransaction->save();


            $userBalance = $userwallet->balance;
            $balance = $userBalance - $userpoint;

            $userwalletadd = UserWallet::where('id', $userwallet->id)->update([
                'user_id' => auth()->user()->id,
                'balance' => $balance
            ]);

            if ($appointment) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Your Appointment is Booked Sucessfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }

    public function previousAppoinments(Request $request)
    {


        try {
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('user_id', auth()->user()->id)->where('Appointment_Date', '<=', date('Y-m-d', strtotime($now)))->orderBy('Appointment_Date', 'DESC')->get();
            foreach ($array as $item) {
                $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time < $givenDateTime) {
                        continue;
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['therapist_name'] = $item->therapist->full_name;
                        $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                        $data[$key]['therapist_designation'] = $item->therapist->designation;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end-time'] = date('h:i A', strtotime($closeTime));
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['therapist_name'] = $item->therapist->full_name;
                    $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                    $data[$key]['therapist_designation'] = $item->therapist->designation;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end-time'] = date('h:i A', strtotime($closeTime));
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $key++;
                }
            }
            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => 0,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function upcomingAppoinments(Request $request)
    {
        try {
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('user_id', auth()->user()->id)->where('Appointment_Date', '<=', date('Y-m-d', strtotime($now)))->orderBy('Appointment_Date', 'DESC')->get();
            foreach ($array as $item) {
                $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {
                        continue;
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['therapist_name'] = $item->therapist->full_name;
                        $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                        $data[$key]['therapist_designation'] = $item->therapist->designation;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end-time'] = date('h:i A', strtotime($closeTime));
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['therapist_name'] = $item->therapist->full_name;
                    $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                    $data[$key]['therapist_designation'] = $item->therapist->designation;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end-time'] = date('h:i A', strtotime($closeTime));
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $key++;
                }
            }
            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => 0,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function addAppoinment(Request $request)
    {
        try {
            $review = new UserReview();
            $review->therapist_id = $request->therapist_id;
            $review->user_id = auth()->user()->id;
            $review->appoinment_id = $request->appoinment_id;
            $review->rate = $request->rate;
            $review->comment = $request->comment;
            $review->save();

            if ($review) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Review added successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }


    public function reviewAppoinment(Request $request)
    {
        $review = UserReview::select(DB::raw('avg(rate) as review'))->where('user_id', auth()->user()->id)->get();

        $data['therapist'] = Therapist::select('id', 'full_name', 'designation', 'language_known', 'image')->where('id', $request->therapist_id)->first();
        $data['therapist']->image = asset('assets/uploads/therapist/') . '/' . $data['therapist']->image;
        $data['therapist']->total_sessions = count(Appointments::where('therapist_id', $request->therapist_id)->where('Appointment_Status', 'Completed')->get());
        $data['therapist']->review_average = number_format($review[0]->review, 1);
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function addPrescription(Request $request)
    {
        try {
            $review = new Prescription();
            $review->therapist_id = $request->therapist_id;
            $review->user_id = auth()->user()->id;
            $review->appoinment_id = $request->appoinment_id;
            $review->note = $request->note;
            $review->save();

            if ($review) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Prescription added successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function addConsulation(Request $request)
    {
        try {
            $review = new ConsulationNote();
            $review->therapist_id = $request->therapist_id;
            $review->user_id = auth()->user()->id;
            $review->appoinment_id = $request->appoinment_id;
            $review->note = $request->note;
            $review->save();

            if ($review) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Consulation added successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function changeAppoinmentStatus(Request $request)
    {
        try {
            if ($request->status == 'Cancel') {
                $res = Appointments::where('id', $request->appoinment_id)
                    ->update([
                        'Appointment_Status' => $request->status,
                        'cancel_reason' => $request->reason
                    ]);
            } elseif ($request->status == 'Resheduled') {
                $res = Appointments::where('id', $request->appoinment_id)
                    ->update([
                        'Appointment_Status' => $request->status,
                        'reshedule_reason' => $request->reason
                    ]);
            } else {
                $res = Appointments::where('id', $request->appoinment_id)
                    ->update([
                        'Appointment_Status' => $request->status
                    ]);
            }

            if ($res) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $request->status . " Your appoinment successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }
}
